<?php
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_server = $_POST['db_server'];
    $db_username = $_POST['db_username'];
    $db_password = $_POST['db_password'];
    $db_name = $_POST['db_name'];
    $base_url = $_POST['base_url'];

    try {
        // Step 1: Test Database Connection
        $conn = new mysqli($db_server, $db_username, $db_password, $db_name);
        if ($conn->connect_error) {
            throw new Exception("Database connection failed. Please check your credentials.");
        }

        // Step 2: Check if Database is Empty
        $result = $conn->query("SHOW TABLES");
        if ($result && $result->num_rows > 0) {
            throw new Exception("Database already contains tables. Please use an empty database.");
        }

        // Step 3: Disable Foreign Key Checks Before Import
        $conn->query("SET FOREIGN_KEY_CHECKS = 0;");

        // Step 4: Import SQL File
        $sqlFile = "database.sql"; 
        if (!file_exists($sqlFile)) throw new Exception("SQL file not found.");

        $sqlContent = file_get_contents($sqlFile);

        if ($conn->multi_query($sqlContent)) {
            // Ensure all queries are executed properly
            do {
                if ($result = $conn->store_result()) {
                    $result->free();
                }
            } while ($conn->more_results() && $conn->next_result());

            // Step 5: Re-enable Foreign Key Checks
            $conn->query("SET FOREIGN_KEY_CHECKS = 1;");
        } else {
            throw new Exception("SQL import failed: " . $conn->error);
        }

        // Step 6: Write Database Credentials to .htaccess (putenv)
        $htaccessContent = <<<EOL

# Application Environment Variables
SetEnv DB_SERVER "$db_server"
SetEnv DB_USERNAME "$db_username"
SetEnv DB_PASSWORD "$db_password"
SetEnv DB_NAME "$db_name"
SetEnv BASE_URL "$base_url"

EOL;

        file_put_contents('../.htaccess', $htaccessContent, FILE_APPEND | LOCK_EX);

        echo json_encode([
            "success" => true,
            "message" => "Database connected! SQL import completed successfully. Configuration saved to .htaccess.",
            "progress" => 100
        ]);

    } catch (Exception $e) {
        echo json_encode(["success" => false, "message" => $e->getMessage()]);
    }

    $conn->close();
    exit;
}
